<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard</title>
    <link rel="stylesheet" href="<?php echo e(asset('css/app.css')); ?>">
</head>
<body>
    <div class="dashboard-container">
        <!-- Sidebar -->
        <div class="sidebar">
            <h2>Dashboard</h2>
            <ul>
                <li><a href="#">Overview</a></li>
                <li><a href="#">Analytics</a></li>
                <li><a href="#">Recent Updates</a></li>
            </ul>
        </div>

        <!-- Main Content -->
        <div class="main-content">
            <h3>Overview</h3>
            <!-- Overview Section -->
            <div class="overview">
                
                <div class="overview-card">
                    <div class="card">
                        <h4>Total Sales</h4>
                        <p class="amount">$15,000</p>
                    </div>
                    <div class="card">
                        <h4>Total Users</h4>
                        <p class="amount">1,500</p>
                    </div>
                    <div class="card">
                        <h4>Active Users</h4>
                        <p class="amount">1,200</p>
                    </div>
                </div>
            </div>

            <!-- Analytics Section -->
            <div class="analytics">
                <h3>Analytics</h3>
                <div class="graph-container">
                    <h2>Sales Performance</h2>
                    <div class="graph">
                        <div class="bar" style="height: 70%;">$700</div>
                        <div class="bar" style="height: 50%;">$500</div>
                        <div class="bar" style="height: 80%;">$800</div>
                        <div class="bar" style="height: 60%;">$600</div>
                        <div class="bar" style="height: 90%;">$900</div>
                    </div>
                    <div class="labels">
                        <span>Jan</span>
                        <span>Feb</span>
                        <span>Mar</span>
                        <span>Apr</span>
                        <span>May</span>
                    </div>
                </div>
            </div>

            <!-- Recent Updates Section -->
            <div class="recent-updates">
                <h3>Recent Updates</h3>
                <ul>
                    <li><span class="update-time">10:00 AM</span> - New sale made, $500</li>
                    <li><span class="update-time">9:45 AM</span> - New user registered</li>
                    <li><span class="update-time">9:30 AM</span> - System update completed</li>
                </ul>
            </div>
        </div>
    </div>
</body>
</html>
<?php /**PATH D:\Projects\onlineadmission\resources\views/welcome.blade.php ENDPATH**/ ?>