<?php
// forgot_password.php
session_start();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = filter_var($_POST['email'], FILTER_SANITIZE_EMAIL);

    // Check if email exists (assuming you have a database connection)
    $conn = mysqli_connect('127.0.0.1', 'manjunimi_manjunimi', '6U0hzt}D(w6j', 'manjunimi_task');
    if (!$conn) die('Connection failed: ' . $conn->connect_error);

    $stmt = $conn->prepare('SELECT id FROM user WHERE email = ?');
    $stmt->bind_param('s', $email);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        date_default_timezone_set("Asia/Kolkata");
        $token = bin2hex(random_bytes(50));
        $stmt = $conn->prepare('UPDATE user SET reset_token = ?, reset_expiry = ? WHERE email = ?');
        $expiry = Date('Y-m-d h:i:s', strtotime('+5 minutes'));
        $stmt->bind_param('sss', $token, $expiry, $email);
        $stmt->execute();

        // Send reset link
        $resetLink = "https://manju.nimi.co.in/loginmaster/updatepassword.php?token=$token";
        mail($email, 'Password Reset Request', "Click this link to reset your password: $resetLink");
        echo 'Reset link has been sent to your email.';
    } else {
        echo 'Email not found.';
    }

    $stmt->close();
    $conn->close();
}
?>

<!-- HTML Form -->
<form method="post">
    Enter your email: <input type="email" name="email" required>
    <button type="submit">Send Reset Link</button>
</form>